package app.firezone.synk.network.Activities;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import android.app.ProgressDialog;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;

import com.squareup.picasso.Picasso;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.ActivityProfileBinding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.User;
import app.firezone.synk.network.model.UserResponse;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

import java.util.HashMap;
import java.util.Map;

public class ProfileActivity extends AppCompatActivity {

    ActivityProfileBinding binding;
    Uri imageUri;

    long userId;

    String password;
    ProgressDialog dialog;
    private MyApi myApi;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityProfileBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        binding.backArrow.setOnClickListener(v -> finish());

        userId = SharedPrefManager.getInstance(ProfileActivity.this).getUserId();

        myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);

        dialog = new ProgressDialog(ProfileActivity.this);
        dialog.setTitle("Profile Uploading");
        dialog.setMessage("We're uploading your profile");

        binding.backArrow.setOnClickListener(v -> finish());

        loadData();

        binding.fetchImage.setOnClickListener(view -> {
            Intent intent = new Intent();
            intent.setAction(Intent.ACTION_GET_CONTENT);
            intent.setType("image/*");
            startActivityForResult(intent, 5);
        });



        binding.passUpdate.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(ProfileActivity.this, ChangePasswordActivity.class);
                intent.putExtra("userId", userId);
                intent.putExtra("password", password);
                startActivity(intent);
            }
        });

        binding.updateBtn.setOnClickListener(view -> {
            String name = binding.name.getText().toString();
            String phone = binding.phone.getText().toString();
            String username = binding.username.getText().toString();

            if (name.isEmpty() || phone.isEmpty() || username.isEmpty()) {
                Toast.makeText(ProfileActivity.this, "Something Went Wrong..", Toast.LENGTH_SHORT).show();
            } else {
                updateData(name, phone, username);
            }
        });
    }

    private void loadData() {

        Call<ApiResponse> call = myApi.fetchProfileData(userId);

        call.enqueue(new Callback<ApiResponse>() {
            @Override
            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    User model = response.body().getUser();
                    binding.balance.setText(String.valueOf(model.getDepoBalance() + model.getBonusBalance() + model.getWinBalance()));
                    binding.debopiste.setText(String.valueOf(model.getMatchPlayed()));
                    binding.name.setText(model.getName());
                    binding.userNameTxt.setText(model.getName());
                    binding.email.setText(model.getEmail());
                    binding.phone.setText(model.getPhoneno());
                    binding.username.setText(model.getUsername());
                    binding.pass.setText("Your Pass: ********* " );

                    password = model.getPassword();

                    Picasso.get().load(model.getProfile()).placeholder(R.drawable.loading_img).into(binding.userProfile);
                }
            }

            @Override
            public void onFailure(Call<ApiResponse> call, Throwable throwable) {

            }
        });
    }

    private void updateData(String name, String phone, String username) {
        long userId = SharedPrefManager.getInstance(ProfileActivity.this).getUserId();
        Map<String, Object> map = new HashMap<>();
        map.put("name", name);
        map.put("username", username);
        map.put("phoneno", phone);

        Call<UserResponse> call = myApi.updateUser(userId, map);
        call.enqueue(new Callback<UserResponse>() {
            @Override
            public void onResponse(Call<UserResponse> call, Response<UserResponse> response) {
                if (response.isSuccessful()) {
                    Toast.makeText(ProfileActivity.this, "Profile Updated Successfully", Toast.LENGTH_SHORT).show();
                } else {
                    Toast.makeText(ProfileActivity.this, "Update Failed", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<UserResponse> call, Throwable t) {
                Toast.makeText(ProfileActivity.this, "Error: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);

        if (requestCode == 5 && data != null) {
            imageUri = data.getData();
            binding.userProfile.setImageURI(imageUri);
            dialog.show();

            // Assume you have an API to upload images instead of Firebase storage
            Toast.makeText(ProfileActivity.this, "Image selected for upload.", Toast.LENGTH_SHORT).show();
            dialog.dismiss();
        }
    }
}